<?php

namespace Tests\Unit;

use App\Filament\Admin\Resources\Users\Forms\UserForm;
use App\Filament\Admin\Resources\Users\Tables\UserTable;
use App\Filament\Admin\Resources\Users\UserResource;
use App\Models\User;
use PHPUnit\Framework\TestCase;

class UserResourceUnitTest extends TestCase
{
    public function test_user_resource_has_correct_model(): void
    {
        $this->assertEquals(User::class, UserResource::getModel());
    }

    public function test_user_resource_has_permission_prefixes(): void
    {
        $prefixes = UserResource::getPermissionPrefixes();

        $this->assertIsArray($prefixes);
        $this->assertContains('view', $prefixes);
        $this->assertContains('create', $prefixes);
        $this->assertContains('update', $prefixes);
        $this->assertContains('delete', $prefixes);
    }

    public function test_user_resource_has_navigation_icon(): void
    {
        $this->assertEquals('heroicon-o-users', UserResource::getNavigationIcon());
    }

    public function test_user_resource_classes_exist(): void
    {
        $this->assertTrue(class_exists(UserForm::class));
        $this->assertTrue(class_exists(UserTable::class));
    }

    public function test_user_form_has_configure_method(): void
    {
        $this->assertTrue(method_exists(UserForm::class, 'configure'));
    }

    public function test_user_table_has_configure_method(): void
    {
        $this->assertTrue(method_exists(UserTable::class, 'configure'));
    }
}
