<?php

return [
    // Navigation & Labels
    'project_charters' => 'Project Charters',
    'project_charter' => 'Project Charter',

    // Form Fields
    'dates_and_costs' => 'Dates and Costs',
    'basic_information' => 'Basic Information',
    'financial_information' => 'Financial Information',
    'performance_tracking' => 'Performance Tracking',
    'charter_number' => 'Charter Number',
    'name' => 'Name',
    'description' => 'Description',
    'start_date' => 'Start Date',
    'expected_end_date' => 'Expected End Date',
    'estimated_cost' => 'Estimated Cost',
    'total_cost' => 'Total Cost',
    'status' => 'Status',
    'initiative_project' => 'Initiative Project',
    'performance_card_results' => 'Performance Card Results',
    'performance_card_results_helper' => 'Select which performance card results this charter will contribute to',
    'project_charter_for_order' => 'Project Charter for Order #:order_number',

    // Status Values
    'draft' => 'Draft',
    'awaiting_approval' => 'Awaiting Approval',
    'approved' => 'Approved',
    'rejected' => 'Rejected',
    'completed' => 'Completed',
    'canceled' => 'Canceled',
    'suspended' => 'Suspended',

    // Helper Text
    'name_helper' => 'Enter a descriptive name for this project charter',
    'description_helper' => 'Provide detailed description of the project charter',
    'date_range_helper' => 'Define the timeframe for this project charter',
    'estimated_cost_helper' => 'Enter the estimated cost for this project',
    'total_cost_helper' => 'Enter the total cost for this project',
    'initiative_project_preselected' => 'Initiative project has been pre-selected',

    // Table Columns
    'payments_count' => 'Payments Count',
    'deliverables_count' => 'Deliverables Count',
    'performance_card_results_count' => 'Performance Card Results Count',
    'payments' => 'Payments',
    'deliverables' => 'Deliverables',
    'deliverable' => 'Deliverable',
    'payment' => 'Payment',

    // Messages
    'created_successfully' => 'Project Charter created successfully',
    'updated_successfully' => 'Project Charter updated successfully',
    'deleted_successfully' => 'Project Charter deleted successfully',
    'view_charter' => 'View Charter',
    'create_charter' => 'Create Charter',

    // Order Linking
    'linked_order' => 'Linked Order',
    'order_selection_helper' => 'Select an order to automatically fill charter details. Only launched orders without existing charters are available.',

    // View Charter UI
    'charter_details' => 'Charter Details',
    'charter_overview' => 'Charter Overview',
    'charter_id' => 'Charter ID',
    'project_manner' => 'Project Manner',
    'no_description' => 'No description provided',
    'project_relationships' => 'Project Relationships',
    'initiative' => 'Initiative',
    'department' => 'Department',
    'timeline' => 'Timeline',
    'duration' => 'Duration',
    'duration_days' => ':days days',
    'cost_difference' => 'Cost Difference',
    'progress_status' => 'Progress Status',
    'not_started' => 'Not Started',
    'in_progress' => 'In Progress',
    'pending' => 'Pending',

    // View Progress Project Charter UI
    'view_progress' => 'View Progress',
    'project_progress' => 'Project Progress',
    'project_completion_percentage' => 'Project Completion Percentage',
    'financial_completion_percentage' => 'Financial Completion Percentage',

    // Tasks Management
    'task' => 'Task',
    'tasks' => 'Tasks',
    'task_name' => 'Task Name',
    'task_description' => 'Task Description',
    'assigned_user' => 'Assigned User',
    'priority' => 'Priority',
    'priority_low' => 'Low',
    'priority_medium' => 'Medium',
    'priority_high' => 'High',
    'priority_urgent' => 'Urgent',
    'due_date' => 'Due Date',
    'completed_date' => 'Completed Date',
    'estimated_hours' => 'Estimated Hours',
    'actual_hours' => 'Actual Hours',
    'est_hours' => 'Est. Hours',
    'progress_percentage' => 'Progress (%)',
    'progress' => 'Progress',
    'estimated_progress' => 'Estimated Progress',
    'progress_deviation' => 'Progress Deviation',
    'notes' => 'Notes',
    'overdue_tasks' => 'Overdue Tasks',
    'completed_tasks' => 'Completed Tasks',
    'in_progress_tasks' => 'In Progress Tasks',
    'created_at' => 'Created At',
    'task_for_deliverable' => 'Task for Deliverable',
    'no_tasks' => 'No tasks found',

    // Task Status
    'status_pending' => 'Pending',
    'status_in_progress' => 'In Progress',
    'status_completed' => 'Completed',
    'status_on_hold' => 'On Hold',
    'status_cancelled' => 'Cancelled',
    'task_status_not_started' => 'Not Started',
    'task_status_in_progress' => 'In Progress',
    'task_status_late' => 'Late',
    'task_status_done' => 'Done',
    'project_status_not_started' => 'Not Started',
    'project_status_in_progress' => 'In Progress',
    'project_status_late' => 'Late',
    'project_status_done' => 'Done',

    // Approval Workflow Actions
    'submit_for_approval' => 'Submit for Approval',
    'approve' => 'Approve',
    'reject' => 'Reject',
    'send_back_to_draft' => 'Send Back to Draft',
    'request_completion_action' => 'Request Completion',
    'request_closure_action' => 'Request Closure',

    // Approval Workflow Messages
    'submitted_for_approval_successfully' => 'Charter submitted for approval successfully',
    'submission_failed' => 'Failed to submit charter for approval',
    'approved_successfully' => 'Charter approved successfully',
    'approval_failed' => 'Failed to approve charter',
    'rejected_successfully' => 'Charter rejected successfully',
    'rejection_failed' => 'Failed to reject charter',
    'sent_back_to_draft_successfully' => 'Charter sent back to draft successfully',
    'send_back_failed' => 'Failed to send charter back to draft',

    // Form Labels & Placeholders
    'submission_notes' => 'Submission Notes',
    'submission_notes_placeholder' => 'Optional notes about the submission...',
    'approval_notes' => 'Approval Notes',
    'approval_notes_placeholder' => 'Optional notes about the approval...',
    'rejection_notes' => 'Rejection Notes',
    'rejection_notes_placeholder' => 'Please provide reason for rejection...',
    'send_back_notes' => 'Send Back Notes',
    'send_back_notes_placeholder' => 'Optional notes about sending back to draft...',

    // Edit Restrictions
    'cannot_edit_non_draft' => 'Cannot edit charter that is not in draft status',

    // Task Deletion Messages
    'cannot_delete_task' => 'Cannot delete task',
    'cannot_delete_last_task_message' => 'Cannot delete the last task of a deliverable. Each deliverable must have at least one task.',
    'cannot_delete_tasks' => 'Cannot delete tasks',
    'cannot_delete_tasks_message' => 'Cannot delete tasks that would leave a deliverable without any tasks. Each deliverable must have at least one task.',

    // Cost Validation Messages
    'cost_exceeded_title' => 'Estimated Cost Limit Exceeded',
    'cost_exceeded_message' => 'The total estimated cost of deliverables would exceed the project charter budget. Charter Budget: :charter_cost | Current Total: :current_total | Available: :available | Requested: :requested',
    'available_budget_info' => 'Charter Budget: :charter_cost | Current Total: :current_total | Available: :available',

    // Initiative Cost Validation Messages
    'initiative_cost_exceeded_title' => 'Initiative Budget Limit Exceeded',
    'initiative_cost_exceeded_message' => 'The total estimated cost of project charters would exceed the initiative budget. Initiative: :initiative_name | Budget: :initiative_budget | Current Total: :current_total | Available: :available | Requested: :requested',
    'initiative_budget_info' => 'Initiative: :initiative_name | Budget: :initiative_budget | Current Total: :current_total | Available: :available',

    // Project Charter Files
    'files' => 'Files',
    'task_files' => 'Task Files',
    'task_files_helper' => 'Upload files related to this task (PDF, Word, Excel, Images, Text files - Max 10MB each)',
    'view_files' => 'View Files',
    'project_files' => 'Project Files',
    'file_name' => 'File Name',
    'file_size' => 'File Size',
    'uploaded_by' => 'Uploaded By',
    'upload_date' => 'Upload Date',
    'upload_file' => 'Upload File',
    'download_file' => 'Download File',
    'view_file' => 'View File',
    'delete_file' => 'Delete File',
    'file_uploaded_successfully' => 'File uploaded successfully',
    'file_updated_successfully' => 'File updated successfully',
    'file_deleted_successfully' => 'File deleted successfully',
    'no_files' => 'No files uploaded',
    'select_file' => 'Select a file to upload',
    'file_type_validation' => 'Only PDF, Word, Excel, images, and text files are allowed',
    'max_file_size' => 'Maximum file size: 10MB',
    'confirm_delete_file' => 'Are you sure you want to delete this file?',
    'file_download_error' => 'Error downloading file',

    // Completion/Closure Workflow
    'completion_reason' => 'Completion Reason',
    'closure_reason' => 'Closure Reason',
    'completion_reason_placeholder' => 'Please provide reason for requesting completion...',

    // Wizard Form Steps
    'closure_type_step' => 'Closure Type & Reason',
    'closure_type_step_description' => 'Select the type of closure and provide a reason',
    'project_summary_step' => 'Project Summary & Details',
    'project_summary_step_description' => 'Review project information and provide closure details',

    // Closure Form Fields
    'closure_details' => 'Closure Details',
    'actual_end_date' => 'Actual End Date',
    'actual_end_date_helper' => 'Enter the actual date when the project ended',
    'learned_lessons' => 'Learned Lessons',
    'learned_lessons_placeholder' => 'Document key lessons learned during the project...',
    'learned_lessons_helper' => 'Capture important insights and knowledge gained',
    'closure_notes' => 'Closure Notes',
    'closure_notes_placeholder' => 'Additional notes about the project closure...',
    'closure_notes_helper' => 'Any additional comments or observations about the closure',
    'closure_attachments' => 'Closure Attachments',
    'closure_attachments_helper' => 'Upload any relevant documents for the closure',
    'closure_attachments_note' => 'Attachments can be added to the completion request after it is created through the completion request management interface.',
    'closure_reason_placeholder' => 'Please provide reason for requesting closure...',
    'completion_requested_successfully' => 'Project completion requested successfully',
    'closure_requested_successfully' => 'Project closure requested successfully',
    'completion_request_failed' => 'Failed to request project completion',
    'closure_request_failed' => 'Failed to request project closure',
    'cannot_request_completion' => 'Cannot request completion for this project',
    'cannot_request_closure' => 'Cannot request closure for this project',
    'completion_not_available_helper' => 'Project completion is not available. Current progress: Project: :project_progress%, Financial: :financial_progress%. Both must be 100% to mark as complete.',

    // Cost Validation Messages
    'estimated_cost_exceeds_initiative_budget' => 'The estimated cost (:estimated_cost) exceeds the available initiative budget. Initiative Budget: :initiative_expected_cost | Remaining Budget: :remaining_budget',

    // Progress and Performance Section
    'progress_and_performance' => 'Progress & Performance',
    'total_expenses' => 'Total Expenses (Completed Requests)',
    'project_progress_percentage' => 'Project Progress Percentage',
    'financial_progress_percentage' => 'Financial Progress Percentage',
    'deviation_percentage' => 'Deviation Percentage',
    'outputs_status' => 'Outputs Status',
    'outputs_not_started' => 'Not Started',
    'outputs_in_progress' => 'In Progress',
    'outputs_completed' => 'Completed',
    'outputs_delayed' => 'Delayed',
    'quarterly_results' => 'Quarterly Results',
    'no_quarterly_results' => 'No quarterly results recorded',
    'quarterly_results_input' => 'Quarterly Results Input',
    'q1_results' => 'Q1 Results',
    'q2_results' => 'Q2 Results',
    'q3_results' => 'Q3 Results',
    'q4_results' => 'Q4 Results',
    'quarterly_results_placeholder' => 'Enter achieved results for this quarter...',

    // Governance Management
    'manage_governance' => 'Manage Governance',
    'governance_overview' => 'Governance Overview',
    'change_requests_count' => 'Change Requests',
    'escalation_requests_count' => 'Escalation Requests',
    'pending_change_requests' => 'Pending Change Requests',
    'pending_escalations' => 'Pending Escalations',
    'back_to_charter' => 'Back to Charter',

    // Cases of Status
    'project_phase' => 'Project Phase',
    'phase' => [
        'initiation' => 'Initiation & Planning',
        'execution' => 'Execution',
        'closure' => 'Closure',
    ],

    // Risk Levels
    'risk_level_low' => 'Low',
    'risk_level_medium' => 'Medium',
    'risk_level_high' => 'High',

    // Risk Management
    'risks' => 'Risks',
    'risk' => 'Risk',
    'risk_name' => 'Risk Name',
    'risk_description' => 'Risk Description',
    'incident_likelihood' => 'Incident Likelihood',
    'impact_level' => 'Impact Level',
    'impact_on_cost' => 'Impact on Cost',
    'impact_on_time' => 'Impact on Time',
    'mitigation_plan' => 'Mitigation Plan',
    'contingency_plan' => 'Contingency Plan',
    'financial_contingency' => 'Financial Contingency',
    'technical_contingency' => 'Technical Contingency',
    'risk_creator' => 'Risk Creator',
];
