<?php

return [
    // Workflow States
    'states' => [
        'running' => 'قيد التشغيل',
        'completed' => 'مكتمل',
        'rejected' => 'مرفوض',
        'canceled' => 'ملغى',
    ],

    // Step States
    'step_states' => [
        'pending' => 'في الانتظار',
        'approved' => 'موافق عليه',
        'rejected' => 'مرفوض',
        'skipped' => 'تم تخطيه',
    ],

    // Status Labels
    'status' => [
        'no_workflow' => 'لا يوجد سير عمل',
        'new' => 'جديد',
        'in_progress' => 'قيد التقدم',
        'step_with_status' => ':step (:status)',
    ],

    // Actions
    'actions' => [
        'start_workflow' => 'بدء سير العمل',
        'review_step' => 'مراجعة / الخطوة التالية',
        'reject_step' => 'رفض الخطوة',
        'approve_step' => 'الموافقة على الخطوة',
        'cancel_workflow' => 'إلغاء سير العمل',
    ],

    // Action Descriptions
    'descriptions' => [
        'start_workflow' => 'بدء عملية سير العمل لهذا العنصر',
        'review_step' => 'مراجعة والموافقة على خطوة سير العمل الحالية',
        'reject_step' => 'رفض خطوة سير العمل الحالية مع التعليقات',
        'approve_step' => 'الموافقة على خطوة سير العمل الحالية',
        'cancel_workflow' => 'إلغاء عملية سير العمل بالكامل',
    ],

    // Form Labels
    'forms' => [
        'current_step' => 'الخطوة الحالية',
        'step_form' => 'نموذج الخطوة',
        'note' => 'ملاحظة',
        'note_help' => 'ملاحظة اختيارية لهذه الخطوة',
        'rejection_reason' => 'سبب الرفض',
        'rejection_reason_help' => 'يرجى تقديم سبب لرفض هذه الخطوة',
        'rejection_reason_required' => 'سبب الرفض مطلوب',
        'cancellation_reason' => 'سبب الإلغاء',
        'cancellation_reason_help' => 'يرجى تقديم سبب لإلغاء سير العمل هذا',
    ],

    // Notifications
    'notifications' => [
        'workflow_started' => 'تم بدء سير العمل بنجاح',
        'workflow_start_failed' => 'فشل في بدء سير العمل',
        'step_approved' => 'تمت الموافقة على الخطوة بنجاح',
        'step_approval_failed' => 'فشل في الموافقة على الخطوة',
        'step_rejected' => 'تم رفض الخطوة بنجاح',
        'step_rejection_failed' => 'فشل في رفض الخطوة',
        'workflow_canceled' => 'تم إلغاء سير العمل بنجاح',
        'workflow_cancel_failed' => 'فشل في إلغاء سير العمل',
        'no_current_step' => 'لم يتم العثور على خطوة حالية',
    ],

    // Activity Log Messages
    'activity' => [
        'workflow_started' => 'تم بدء سير العمل',
        'workflow_auto_started' => 'تم التهيئة التلقائية عند عرض السجل',
        'step_approved' => 'تمت الموافقة على الخطوة \':from_step\'',
        'step_approved_with_next' => 'تمت الموافقة على الخطوة \':from_step\' → \':to_step\'',
        'step_approved_completed' => 'تمت الموافقة على الخطوة \':from_step\' (مكتملة)',
        'step_rejected' => 'تم رفض الخطوة \':step\': :reason',
        'workflow_completed' => 'تم إكمال سير العمل بنجاح',
        'workflow_canceled' => 'تم إلغاء سير العمل: :reason',
        'step_approved_by' => 'تمت الموافقة على \':from_step\' بواسطة :name',
        'step_status_changed' => 'تم تغيير الحالة من <strong>:from_step</strong> إلى <strong>:to_step</strong>.',
        'step_rejected_by' => 'تم رفض \':from_step\' بواسطة :name',
        'step_status_was' => 'كانت الحالة <strong>:status</strong>.',
        'workflow_completed_by' => 'تم إكمال سير العمل بواسطة :name.',
        'workflow_notes' => 'ملاحظات: :notes',
        'workflow_notes_na' => 'لا توجد ملاحظات',
    ],

    // Errors
    'errors' => [
        'no_active_template' => 'لم يتم العثور على قالب سير عمل نشط لـ :model',
        'only_pending_can_be_approved' => 'يمكن الموافقة على الخطوات المعلقة فقط',
        'only_pending_can_be_rejected' => 'يمكن رفض الخطوات المعلقة فقط',
        'user_not_authenticated' => 'يجب مصادقة المستخدم لتنفيذ إجراءات سير العمل',
        'no_permission' => 'المستخدم ليس لديه صلاحية: :permission',
        'validation_failed' => 'فشل التحقق: :error',
        'cannot_cancel_completed' => 'لا يمكن إلغاء سير عمل مكتمل',
        'handler_not_whitelisted' => 'فئة المعالج :class غير مدرجة في القائمة البيضاء',
        'handler_not_found' => 'فئة المعالج :class غير موجودة',
        'handler_invalid' => 'المعالج :class يجب أن ينفذ واجهة StepHandler',
    ],

    // Confirmations
    'confirmations' => [
        'reject_step' => 'هل أنت متأكد من أنك تريد رفض هذه الخطوة؟',
        'cancel_workflow' => 'هل أنت متأكد من أنك تريد إلغاء سير العمل هذا؟',
        'start_workflow' => 'هل أنت متأكد من أنك تريد بدء سير العمل؟',
    ],

    // General
    'general' => [
        'workflow' => 'سير العمل',
        'workflows' => 'سيرة العمل',
        'step' => 'خطوة',
        'steps' => 'خطوات',
        'status' => 'الحالة',
        'actions' => 'الإجراءات',
        'history' => 'التاريخ',
        'details' => 'التفاصيل',
        'progress' => 'التقدم',
        'version' => 'الإصدار',
    ],

    // Tab Permissions
    'tab_permissions' => [
        'view_all' => 'عرض تبويب الكل',
        'view_new' => 'عرض تبويب الجديد',
        'view_completed' => 'عرض تبويب المكتملة',
        'view_rejected' => 'عرض تبويب المرفوضة',
        'view_step' => 'عرض تبويب الخطوة',
    ],

    // Workflow Templates
    'templates' => [
        // Resource Labels
        'singular_label' => 'قالب سير العمل',
        'plural_label' => 'قوالب سير العمل',
        'navigation_label' => 'قوالب سير العمل',
        'navigation_group' => 'إدارة سير العمل',

        // Page Titles
        'list_title' => 'قوالب سير العمل',
        'create_title' => 'إنشاء قالب سير العمل',
        'edit_title' => 'تحرير قالب سير العمل',

        // Form Fields
        'name' => 'الاسم',
        'name_help' => 'اسم وصفي لقالب سير العمل',
        'description' => 'الوصف',
        'description_help' => 'وصف تفصيلي لغرض ونطاق قالب سير العمل',
        'subject_type' => 'نوع الموضوع',
        'subject_type_help' => 'نوع النموذج الذي سيتم تطبيق سير العمل عليه',
        'subject_type_placeholder' => 'اختر نوع الموضوع',
        'is_active' => 'نشط',
        'is_active_help' => 'فقط القوالب النشطة يمكن تطبيقها على الكيانات الجديدة',
        'status' => 'الحالة',
        'version' => 'الإصدار',
        'published_at' => 'تاريخ النشر',
        'not_published' => 'غير منشور',
        'draft' => 'مسودة',

        // Table Columns
        'table_name' => 'الاسم',
        'table_description' => 'الوصف',
        'table_subject_type' => 'نوع الموضوع',
        'table_active' => 'نشط',
        'table_steps' => 'الخطوات',
        'table_created' => 'تم الإنشاء',
        'table_updated' => 'تم التحديث',

        // Active States
        'active' => 'نشط',
        'inactive' => 'غير نشط',
        'yes' => 'نعم',
        'no' => 'لا',

        // Filters
        'filter_active' => 'حالة النشاط',
        'filter_subject_type' => 'نوع الموضوع',

        // Status Options
        'status_draft' => 'مسودة',
        'status_published' => 'منشور',
        'status_archived' => 'مؤرشف',

        // Actions
        'actions' => [
            'create' => 'إنشاء',
            'edit' => 'تحرير',
            'delete' => 'حذف',
            'view' => 'عرض',
            'save' => 'حفظ',
            'cancel' => 'إلغاء',
            'publish' => 'نشر',
            'clone' => 'استنسخ',
        ],

        // Notifications
        'created' => 'تم إنشاء قالب سير العمل بنجاح',
        'updated' => 'تم تحديث قالب سير العمل بنجاح',
        'deleted' => 'تم حذف قالب سير العمل بنجاح',
        'published' => 'تم نشر القالب بنجاح',
        'publish_failed' => 'فشل في نشر القالب',
        'cloned' => 'تم استنساخ القالب بنجاح',
        'cloned_body' => 'تم إنشاء قالب مسودة: :name',

        // Step Template Relation Manager
        'step_templates' => [
            'tab_label' => 'خطوات القالب',
            'heading' => 'خطوات القالب',

            // Form Fields
            'name' => 'اسم الخطوة',
            'name_help' => 'اسم وصفي للخطوة',
            'description' => 'الوصف',
            'description_help' => 'وصف تفصيلي لغرض الخطوة',
            'position' => 'الموضع',
            'position_help' => 'ترتيب الخطوة في سير العمل',
            'type' => 'النوع',
            'type_help' => 'نوع الخطوة (الموافقة، الإخطار، إلخ)',
            'assignee_type' => 'نوع المعين',
            'assignee_type_help' => 'كيفية تعيين هذه الخطوة للمستخدمين',
            'assignee_id' => 'المعين',
            'assignee_id_help' => 'المستخدم المحدد المعين لهذه الخطوة',
            'role_id' => 'الدور',
            'role_id_help' => 'الدور المطلوب لهذه الخطوة',
            'department_id' => 'القسم',
            'department_id_help' => 'القسم المطلوب لهذه الخطوة',
            'is_locked' => 'مقفل',
            'is_locked_help' => 'الخطوات المقفلة لا يمكن تحريرها أو حذفها',
            'system_key' => 'مفتاح النظام',
            'system_key_help' => 'معرف فريد للخطوات المطلوبة للنظام',
            'validation' => 'التحقق',
            'validation_help' => 'قواعد التحقق لهذه الخطوة (JSON)',
            'data_bindings' => 'ربط البيانات',
            'data_bindings_help' => 'تكوين ربط البيانات لهذه الخطوة (JSON)',
            'form_definition' => 'تعريف النموذج',
            'form_definition_help' => 'تعريف النموذج الإضافي لهذه الخطوة (JSON)',
            'step_template_key' => 'قالب الخطوة',
            'step_template_key_help' => 'قالب خطوة محدد مسبقاً لملء هذه الخطوة',
            'step_template' => 'قالب الخطوة',
            'step_template_help' => 'اختر قالب محدد مسبقاً مع حقول النماذج والتحقق',
            'locked' => 'مقفل',
            'form' => 'نموذج',
            'template' => 'قالب',
            'none_placeholder' => 'لا يوجد',
            'basic_step' => 'خطوة أساسية',
            'system_key_required' => 'مفتاح النظام المطلوب لهذا سير العمل',
            'system_key_optional' => 'مفتاح النظام الاختياري',
            'system_key_none' => 'لا يوجد',
            'no_key_assigned' => 'لا يوجد مفتاح نظام مخصص',
            'required_keys_help' => 'مفاتيح النظام المطلوبة لهذا سير العمل: :keys',
            'choose_key_help' => 'اختر مفتاح النظام لتحديد نوع هذه الخطوة',
            'type_approval' => 'موافقة',
            'type_input' => 'إدخال',
            'type_auto' => 'تلقائي',

            // Step Types
            'types' => [
                'approval' => 'موافقة',
                'notification' => 'إخطار',
                'review' => 'مراجعة',
                'data_entry' => 'إدخال البيانات',
            ],

            // Assignee Types
            'assignee_types' => [
                'user' => 'مستخدم محدد',
                'role' => 'دور',
                'department' => 'قسم',
                'creator' => 'منشئ الطلب',
                'manager' => 'المدير',
                'auto' => 'تلقائي',
            ],

            // Step Template Options
            'template_options' => [
                'none' => 'لا يوجد قالب',
                'auto_detect' => 'الكشف التلقائي',
            ],

            // Table Columns
            'table_name' => 'اسم الخطوة',
            'table_description' => 'الوصف',
            'table_position' => 'الموضع',
            'table_type' => 'النوع',
            'table_assignee_type' => 'نوع المعين',
            'table_assignee' => 'المعين',
            'table_locked' => 'مقفل',
            'table_system' => 'نظام',

            // Actions
            'create' => 'إضافة خطوة',
            'edit' => 'تحرير الخطوة',
            'delete' => 'حذف الخطوة',

            // Validation Messages
            'cannot_delete_system' => 'لا يمكن حذف خطوات النظام',
            'cannot_edit_locked' => 'لا يمكن تحرير الخطوات المقفلة',

            // Notifications
            'created' => 'تم إنشاء الخطوة بنجاح',
            'updated' => 'تم تحديث الخطوة بنجاح',
            'deleted' => 'تم حذف الخطوة بنجاح',
        ],
    ],
];
