<?php

namespace Database\Seeders;

use App\Models\Department;
use App\Models\GrantArea;
use App\Models\Org;
use App\Models\PerformanceCard;
use App\Models\PerformanceWallet;
use App\Models\User;
use Illuminate\Database\Seeder;

class PerformanceCardSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first organization, department, and user
        $org = Org::first() ?? Org::create(['name' => 'مؤسسة سدو']);
        $department = Department::first() ?? Department::factory()->create(['org_id' => $org->id]);
        $user = User::first() ?? User::factory()->create();

        $performanceCards = [
            [
                'project_manner' => 'developmental',
                'goal' => 'تطوير قدرات الموظفين في مجال التقنية والابتكار لتحسين الأداء المؤسسي',
                'org_id' => $org->id,
                'department_id' => $department->id,
                'created_by' => $user->id,
            ],
            [
                'project_manner' => 'support',
                'goal' => 'دعم الأسر المحتاجة من خلال برامج المساعدات المالية والعينية',
                'org_id' => $org->id,
                'department_id' => $department->id,
                'created_by' => $user->id,
            ],
            [
                'project_manner' => 'empowerment',
                'goal' => 'تمكين الشباب من خلال برامج التدريب المهني وتطوير المهارات القيادية',
                'org_id' => $org->id,
                'department_id' => $department->id,
                'created_by' => $user->id,
            ],
            [
                'project_manner' => 'investment',
                'goal' => 'استثمار الموارد المالية في مشاريع مستدامة تحقق عوائد طويلة المدى',
                'org_id' => $org->id,
                'department_id' => $department->id,
                'created_by' => $user->id,
            ],
        ];

        foreach ($performanceCards as $cardData) {
            $card = PerformanceCard::create($cardData);

            // Create a wallet for this performance card
            $wallet = PerformanceWallet::create([
                'name' => 'محفظة أداء - '.$card->goal,
                'description' => 'محفظة الأداء المخصصة لتتبع المبادرات والمشاريع المرتبطة بهذا الهدف',
                'start_date' => now(),
                'expected_end_date' => now()->addMonths(12),
                'performance_card_id' => $card->id,
                'created_by' => $user->id,
            ]);

            // Attach random grant areas (if any exist)
            $grantAreas = GrantArea::inRandomOrder()->limit(rand(1, 3))->get();
            if ($grantAreas->count() > 0) {
                $card->grantAreas()->attach($grantAreas->pluck('id'));
            }

            // Attach random assignees (users)
            $assignees = User::inRandomOrder()->limit(rand(1, 2))->get();
            if ($assignees->count() > 0) {
                $card->assignees()->attach($assignees->pluck('id'));
            }

            // Create some results for each card
            for ($i = 0; $i < rand(2, 4); $i++) {
                $card->results()->create([
                    'name' => 'نتيجة '.($i + 1).' - '.fake()->sentence(3),
                    'created_by' => $user->id,
                ]);
            }
        }

        $this->command->info('تم إنشاء '.count($performanceCards).' بطاقة أداء مع المحافظ ومجالات المنح والمعينين والنتائج');
    }
}
