<?php

namespace Database\Seeders;

use App\Models\PerformanceCard;
use App\Models\PerformanceCardResult;
use App\Models\User;
use Illuminate\Database\Seeder;

class PerformanceCardResultSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // This seeder is optional since results are created in PerformanceCardSeeder
        // Can be used for additional results if needed

        $performanceCards = PerformanceCard::all();

        if ($performanceCards->isEmpty()) {
            $this->command->warn('No performance cards found. Run PerformanceCardSeeder first.');

            return;
        }

        $user = User::first();

        foreach ($performanceCards as $card) {
            // Add 1-2 additional results per card
            for ($i = 0; $i < rand(1, 2); $i++) {
                PerformanceCardResult::create([
                    'performance_card_id' => $card->id,
                    'name' => 'نتيجة إضافية - '.fake()->sentence(4),
                    'created_by' => $user->id,
                ]);
            }
        }

        $this->command->info('Added additional results to performance cards');
    }
}
