<?php

namespace Database\Seeders;

use App\Models\Initiative;
use App\Models\InitiativeProject;
use App\Models\User;
use Illuminate\Database\Seeder;

class InitiativeProjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::first();
        $initiatives = Initiative::all();

        if ($initiatives->isEmpty()) {
            $this->command->warn('No initiatives found. Please run InitiativeSeeder first.');

            return;
        }

        $projectsData = [
            // Projects for تطوير قدرات الموظفين initiatives
            [
                'initiative_keyword' => 'التدريب التقني',
                'projects' => [
                    ['name' => 'تدريب الذكاء الاصطناعي', 'weight' => 40.00],
                    ['name' => 'ورش البرمجة المتقدمة', 'weight' => 35.00],
                    ['name' => 'شهادات التقنية المعتمدة', 'weight' => 25.00],
                ],
            ],
            [
                'initiative_keyword' => 'مختبر الابتكار',
                'projects' => [
                    ['name' => 'إعداد مساحة العمل', 'weight' => 30.00],
                    ['name' => 'تجهيز الأدوات والمعدات', 'weight' => 45.00],
                    ['name' => 'برامج التدريب على الابتكار', 'weight' => 25.00],
                ],
            ],

            // Projects for دعم الأسر المحتاجة initiatives
            [
                'initiative_keyword' => 'المساعدات المالية',
                'projects' => [
                    ['name' => 'تقييم الحالات الطارئة', 'weight' => 20.00],
                    ['name' => 'صرف المساعدات النقدية', 'weight' => 60.00],
                    ['name' => 'متابعة الأسر المستفيدة', 'weight' => 20.00],
                ],
            ],
            [
                'initiative_keyword' => 'السلال الغذائية',
                'projects' => [
                    ['name' => 'شراء المواد الغذائية', 'weight' => 50.00],
                    ['name' => 'تعبئة وتغليف السلال', 'weight' => 20.00],
                    ['name' => 'توزيع السلال على الأسر', 'weight' => 30.00],
                ],
            ],

            // Projects for تمكين الشباب initiatives
            [
                'initiative_keyword' => 'أكاديمية القيادة',
                'projects' => [
                    ['name' => 'دورات المهارات القيادية', 'weight' => 45.00],
                    ['name' => 'ورش الإدارة والتخطيط', 'weight' => 35.00],
                    ['name' => 'مشاريع تطبيقية', 'weight' => 20.00],
                ],
            ],
            [
                'initiative_keyword' => 'حاضنة المشاريع',
                'projects' => [
                    ['name' => 'تقييم المشاريع الريادية', 'weight' => 25.00],
                    ['name' => 'توفير التمويل الأولي', 'weight' => 50.00],
                    ['name' => 'التوجيه والإرشاد', 'weight' => 25.00],
                ],
            ],

            // Projects for استثمار الموارد initiatives
            [
                'initiative_keyword' => 'صندوق الاستثمار',
                'projects' => [
                    ['name' => 'دراسة الفرص الاستثمارية', 'weight' => 30.00],
                    ['name' => 'تنويع المحفظة الاستثمارية', 'weight' => 45.00],
                    ['name' => 'مراقبة الأداء والعوائد', 'weight' => 25.00],
                ],
            ],
            [
                'initiative_keyword' => 'الطاقة المتجددة',
                'projects' => [
                    ['name' => 'مشروع الطاقة الشمسية', 'weight' => 60.00],
                    ['name' => 'مشروع طاقة الرياح', 'weight' => 40.00],
                ],
            ],
        ];

        $createdProjects = [];

        foreach ($projectsData as $projectGroup) {
            // Find the appropriate initiative based on the keyword
            $initiative = $initiatives->first(function ($init) use ($projectGroup) {
                return str_contains($init->name, $projectGroup['initiative_keyword']);
            });

            if (! $initiative) {
                continue;
            }

            foreach ($projectGroup['projects'] as $projectData) {
                $project = InitiativeProject::create([
                    'initiative_id' => $initiative->id,
                    'name' => $projectData['name'],
                    'weight' => $projectData['weight'],
                    'created_by' => $user->id,
                ]);

                $createdProjects[] = $project;
            }
        }

        $this->command->info('تم إنشاء '.count($createdProjects).' مشروع مبادرة عبر '.$initiatives->count().' مبادرة');
    }
}
