<?php

namespace Database\Seeders;

use App\Models\GrantArea;
use App\Models\Org;
use Illuminate\Database\Seeder;

class GrantAreaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first organization (or create one if none exists)
        $orgs = Org::all();

        foreach ($orgs as $org) {
            $grantAreas = [
                [
                    'name' => 'رعاية الأيتام والأطفال',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'الرعاية الصحية',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'التعليم والتدريب',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'رعاية كبار السن',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'الإغاثة والطوارئ',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'التنمية المجتمعية',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'رعاية ذوي الاحتياجات الخاصة',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'برامج الإسكان والمأوى',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'الأمن الغذائي',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'حماية البيئة',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'تمكين المرأة',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'رعاية الشباب',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'الثقافة والفنون',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'الرياضة والأنشطة البدنية',
                    'org_id' => $org->id,
                ],
                [
                    'name' => 'التوعية الصحية',
                    'org_id' => $org->id,
                ],
            ];

            foreach ($grantAreas as $grantAreaData) {
                GrantArea::create($grantAreaData);
            }
        }

        $this->command->info('تم إنشاء '.count($grantAreas).' مجال منح');
    }
}
