<?php

namespace Database\Seeders;

use App\Models\DonorPortfolio;
use App\Models\Org;
use App\Models\User;
use Illuminate\Database\Seeder;

class DonorPortfolioSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first organization (or create one if none exists)
        $org = Org::first() ?? Org::create(['name' => 'مؤسسة سدو']);

        // Get the first user (or create one if none exists)
        $user = User::first() ?? User::factory()->create();

        $portfolios = [
            [
                'name' => 'General Donations',
                'balance' => 150000.00,
                'org_id' => $org->id,
                'created_by' => $user->id,
            ],
            [
                'name' => 'Emergency Fund',
                'balance' => 75000.00,
                'org_id' => $org->id,
                'created_by' => $user->id,
            ],
            [
                'name' => 'Educational Programs',
                'balance' => 250000.00,
                'org_id' => $org->id,
                'created_by' => $user->id,
            ],
            [
                'name' => 'Healthcare Initiative',
                'balance' => 180000.00,
                'org_id' => $org->id,
                'created_by' => $user->id,
            ],
            [
                'name' => 'Community Development',
                'balance' => 95000.00,
                'org_id' => $org->id,
                'created_by' => $user->id,
            ],
        ];

        foreach ($portfolios as $portfolioData) {
            DonorPortfolio::create($portfolioData);
        }

        $this->command->info('تم إنشاء '.count($portfolios).' محفظة متبرعين');
    }
}
