<?php

namespace Database\Seeders;

use App\Models\Department;
use App\Models\Org;
use Illuminate\Database\Seeder;

class DepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first organization (or create one if none exists)
        $org = Org::first() ?? Org::create(['name' => 'مؤسسة سدو']);

        $departments = [
            [
                'name' => 'إدارة الجودة والتطوير',
                'description' => 'قسم مختص بضمان جودة الخدمات المقدمة وتطوير العمليات والإجراءات لتحسين الأداء العام للمؤسسة.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'الشؤون المالية والإدارية',
                'description' => 'قسم يتولى إدارة الشؤون المالية والمحاسبية وإدارة الموارد البشرية والعمليات الإدارية اليومية.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'التخطيط الاستراتيجي',
                'description' => 'قسم مسؤول عن وضع الخطط الاستراتيجية طويلة المدى وتطوير السياسات والإجراءات المؤسسية.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'المراجعة والرقابة الداخلية',
                'description' => 'قسم يقوم بمراجعة العمليات الداخلية وضمان الامتثال للقوانين واللوائح والسياسات المعتمدة.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'الاتصال المؤسسي والعلاقات العامة',
                'description' => 'قسم يتولى إدارة التواصل مع الجمهور ووسائل الإعلام وبناء علاقات قوية مع الشركاء والمستفيدين.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'تقنية المعلومات',
                'description' => 'قسم مختص بإدارة البنية التحتية التقنية وتطوير الأنظمة الإلكترونية وضمان أمن المعلومات.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'إدارة المنح والمشاريع',
                'description' => 'قسم يتولى إدارة ومتابعة المنح والمشاريع الخيرية من التخطيط وحتى التنفيذ والتقييم.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'الشؤون القانونية',
                'description' => 'قسم يقدم الاستشارات القانونية ويتولى الأمور القانونية والتعاقدات والامتثال للأنظمة واللوائح.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'التدريب وتطوير القدرات',
                'description' => 'قسم مسؤول عن تطوير قدرات الموظفين والمتطوعين وتنظيم البرامج التدريبية المتخصصة.',
                'org_id' => $org->id,
            ],
            [
                'name' => 'إدارة المخاطر والامتثال',
                'description' => 'قسم يحدد ويدير المخاطر المؤسسية ويضمن الامتثال للمعايير والمتطلبات التنظيمية.',
                'org_id' => $org->id,
            ],
        ];

        foreach ($departments as $departmentData) {
            Department::create($departmentData);
        }

        $this->command->info('تم إنشاء '.count($departments).' إدارة');
    }
}
