<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charter_risks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('org_id')->constrained()->cascadeOnDelete();
            $table->foreignId('project_charter_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->text('description')->nullable();
            $table->enum('incident_likelihood', ['low', 'medium', 'high']);
            $table->enum('impact_level', ['low', 'medium', 'high']);
            $table->decimal('impact_on_cost', 15, 2)->nullable()->comment('Financial impact amount');
            $table->integer('impact_on_time')->nullable()->comment('Time impact in days');
            $table->text('mitigation_plan')->nullable();
            $table->text('contingency_plan')->nullable();
            $table->decimal('financial_contingency', 15, 2)->nullable();
            $table->decimal('technical_contingency', 15, 2)->nullable();
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charter_risks');
    }
};
