<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_charters', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->enum('state', ['active', 'completed', 'canceled', 'suspended']);
            $table->date('start_date');
            $table->date('expected_end_date');
            $table->decimal('total_cost', 15, 2)->default(0.00);
            $table->foreignId('initiative_project_id')->constrained()->cascadeOnDelete();
            $table->foreignId('initiative_id')->constrained()->cascadeOnDelete();
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->foreignId('org_id')->constrained('orgs')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();

            // Ensure one charter per initiative project
            $table->unique('initiative_project_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_charters');
    }
};
