<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();

            // Basic project information
            $table->string('name', 200);
            $table->text('idea'); // max 5000 chars - enforced in model

            // Foreign key relationships
            $table->foreignId('grant_area_id')->constrained('grant_areas')->onDelete('cascade');
            $table->foreignId('state_id')->constrained('states')->onDelete('cascade');
            $table->foreignId('city_id')->constrained('cities')->onDelete('cascade');
            $table->foreignId('association_id')->constrained('associations')->onDelete('cascade');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->foreignId('org_id')->constrained('orgs')->onDelete('cascade');

            // Project details
            $table->decimal('lat', 10, 8);
            $table->decimal('lng', 11, 8);
            $table->date('start_date');
            $table->integer('duration_months')->unsigned();
            $table->string('target_group_type', 120);
            $table->integer('beneficiaries_count')->unsigned();

            // Narrative sections
            $table->text('goals'); // max 5000 chars - enforced in model
            $table->text('strengths'); // max 5000 chars - enforced in model
            $table->text('risks'); // max 5000 chars - enforced in model

            // Declaration checkbox
            $table->boolean('declaration_checked')->default(false);

            $table->softDeletes();
            $table->timestamps();

            // Ensure city belongs to the selected state
            $table->index(['state_id', 'city_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
