<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('associations', function (Blueprint $table) {
            $table->id();

            $table->string('name', 255);

            $table->string('license_number', 255);
            $table->date('license_expiration_date');

            $table->foreignIdFor(\App\Models\Org::class)
                ->constrained()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\User::class)
                ->constrained()->cascadeOnDelete();

            $table->decimal('lat', 10, 8)->nullable();
            $table->decimal('lng', 11, 8)->nullable();

            $table->string('city')->nullable();
            $table->string('street')->nullable();
            $table->string('district')->nullable();
            $table->string('building_number')->nullable();
            $table->string('secondary_number')->nullable();
            $table->string('postal_code')->nullable();

            $table->string('iban')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('account_holder_name')->nullable();

            $table->boolean('is_verified')->default(false);
            $table->boolean('is_locked')->default(false);

            $table->softDeletes();
            $table->timestamps();

            $table->unique(['org_id', 'license_number']);
        });

        // Create pivot tables for many-to-many relationships with states, cities, and centers tables
        Schema::create('association_state', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\Association::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\State::class)->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['association_id', 'state_id']);
        });

        Schema::create('association_city', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\Association::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\City::class)->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['association_id', 'city_id']);
        });

        Schema::create('association_center', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\Association::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\Center::class)->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['association_id', 'center_id']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('associations');
    }
};
