<?php

namespace Database\Factories;

use App\Models\ProjectCharterDeliverable;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectCharterDeliverableTask>
 */
class ProjectCharterDeliverableTaskFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $taskNames = [
            'جمع وتحليل البيانات',
            'إعداد التصميم الأولي',
            'مراجعة وتقييم المتطلبات',
            'تطوير النموذج الأولي',
            'اختبار وتجريب النظام',
            'توثيق الإجراءات',
            'تدريب الفريق المختص',
            'تنفيذ المرحلة التجريبية',
            'مراجعة النتائج الأولية',
            'تحضير التقرير النهائي',
            'تنسيق مع الأقسام المعنية',
            'ضمان الجودة والامتثال',
        ];

        $startDate = $this->faker->dateTimeBetween('-3 months', '+3 months');
        $endDate = $this->faker->dateTimeBetween($startDate, '+6 months');

        return [
            'project_charter_deliverable_id' => ProjectCharterDeliverable::factory(),
            'name' => $this->faker->randomElement($taskNames),
            'description' => $this->faker->paragraph(1),
            'start_date' => $startDate,
            'end_date' => $endDate,
            'progress_percentage' => $this->faker->randomFloat(2, 0, 100),
            'cost' => $this->faker->randomFloat(2, 1000, 25000),
            'created_by' => User::factory(),
        ];
    }
}
