<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PerformanceCard>
 */
class PerformanceCardFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'project_manner' => fake()->randomElement(\App\Enums\ProjectManner::cases())->value,
            'goal' => fake()->paragraph(3),
            'org_id' => function () {
                return \App\Models\Org::first()?->id ?? \App\Models\Org::create(['name' => 'Test Organization'])->id;
            },
            'department_id' => function () {
                return \App\Models\Department::first()?->id ?? \App\Models\Department::factory()->create()->id;
            },
            'created_by' => \App\Models\User::factory(),
        ];
    }
}
