<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\OrderRequirement>
 */
class OrderRequirementFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->randomElement([
                'مستندات الهوية المطلوبة',
                'تقرير مالي مفصل',
                'خطة تنفيذ المشروع',
                'رسائل التوصية المطلوبة',
                'تقرير دراسة الجدوى',
                'موافقات الجهات المختصة',
                'قائمة المستفيدين المستهدفين',
                'تقرير التقييم البيئي',
                'نموذج العقد المبدئي',
                'خطة إدارة المخاطر',
            ]),
            'status' => fake()->randomElement(['pending', 'approved', 'rejected', 'ask_modification']),
            'order_id' => 1, // Use existing order ID
            'created_by' => 1, // Use existing user ID
        ];
    }
}
