<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Initiative>
 */
class InitiativeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $startDate = fake()->dateTimeBetween('now', '+1 month');

        return [
            'name' => fake()->words(3, true),
            'description' => fake()->optional(0.8)->paragraph(2),
            'start_date' => $startDate,
            'expected_end_date' => fake()->dateTimeBetween($startDate, '+6 months'),
            'performance_card_id' => \App\Models\PerformanceCard::factory(),
            'created_by' => \App\Models\User::factory(),
        ];
    }
}
