<?php

declare(strict_types=1);

namespace App\Workflows\Policies;

use App\Workflows\Models\WorkflowTemplate;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Foundation\Auth\User as AuthUser;

class WorkflowTemplatePolicy
{
    use HandlesAuthorization;

    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:WorkflowTemplate');
    }

    public function view(AuthUser $authUser, WorkflowTemplate $workflowTemplate): bool
    {
        return $authUser->can('View:WorkflowTemplate');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:WorkflowTemplate');
    }

    public function update(AuthUser $authUser, WorkflowTemplate $workflowTemplate): bool
    {
        return $authUser->can('Update:WorkflowTemplate');
    }

    public function delete(AuthUser $authUser, WorkflowTemplate $workflowTemplate): bool
    {
        return $authUser->can('Delete:WorkflowTemplate');
    }

    public function restore(AuthUser $authUser, WorkflowTemplate $workflowTemplate): bool
    {
        return $authUser->can('Restore:WorkflowTemplate');
    }

    public function forceDelete(AuthUser $authUser, WorkflowTemplate $workflowTemplate): bool
    {
        return $authUser->can('ForceDelete:WorkflowTemplate');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:WorkflowTemplate');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:WorkflowTemplate');
    }

    public function replicate(AuthUser $authUser, WorkflowTemplate $workflowTemplate): bool
    {
        return $authUser->can('Replicate:WorkflowTemplate');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:WorkflowTemplate');
    }
}
