<?php

namespace App\Workflows\Contracts;

use App\Workflows\Models\StepInstance;
use App\Workflows\Models\WorkflowInstance;
use App\Workflows\Models\WorkflowTemplate;

/**
 * Workflow runtime engine interface
 */
interface WorkflowRuntime
{
    /**
     * Ensure a workflow instance exists for the given subject
     */
    public function ensureInstance(object $subject, ?WorkflowTemplate $template = null): WorkflowInstance;

    /**
     * Get the current step for a subject
     */
    public function currentStep(object $subject): ?StepInstance;

    /**
     * Approve a step with the given payload
     */
    public function approveStep(StepInstance $step, array $payload = [], ?string $note = null): void;

    /**
     * Reject a step with the given reason
     */
    public function rejectStep(StepInstance $step, ?string $reason = null, array $payload = []): void;

    /**
     * Cancel a workflow instance
     */
    public function cancel(WorkflowInstance $instance, ?string $reason = null): void;
}
