<?php

namespace App\Workflows\Contracts;

use App\Workflows\Models\StepInstance;
use App\Workflows\Models\StepTemplate;
use App\Workflows\Models\WorkflowInstance;

/**
 * Step handler interface for custom step processing
 */
interface StepHandler
{
    /**
     * Get extra validation rules for this step
     */
    public function extraRules(StepTemplate $template, WorkflowInstance $instance): array;

    /**
     * Persist step data to domain models
     */
    public function persist(StepTemplate $template, WorkflowInstance $instance, StepInstance $step, array $data): void;

    /**
     * Called after step is approved
     */
    public function afterApprove(StepTemplate $template, WorkflowInstance $instance, StepInstance $step): void;
}
