<?php

declare(strict_types=1);

namespace App\Policies;

use App\Models\DonorPortfolio;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Foundation\Auth\User as AuthUser;

class DonorPortfolioPolicy
{
    use HandlesAuthorization;

    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:DonorPortfolio');
    }

    public function view(AuthUser $authUser, DonorPortfolio $donorPortfolio): bool
    {
        return $authUser->can('View:DonorPortfolio');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:DonorPortfolio');
    }

    public function update(AuthUser $authUser, DonorPortfolio $donorPortfolio): bool
    {
        return $authUser->can('Update:DonorPortfolio');
    }

    public function delete(AuthUser $authUser, DonorPortfolio $donorPortfolio): bool
    {
        return $authUser->can('Delete:DonorPortfolio');
    }

    public function restore(AuthUser $authUser, DonorPortfolio $donorPortfolio): bool
    {
        return $authUser->can('Restore:DonorPortfolio');
    }

    public function forceDelete(AuthUser $authUser, DonorPortfolio $donorPortfolio): bool
    {
        return $authUser->can('ForceDelete:DonorPortfolio');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:DonorPortfolio');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:DonorPortfolio');
    }

    public function replicate(AuthUser $authUser, DonorPortfolio $donorPortfolio): bool
    {
        return $authUser->can('Replicate:DonorPortfolio');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:DonorPortfolio');
    }
}
