<?php

namespace App\Models;

use App\Workflows\Models\WorkflowTemplate;
use Database\Factories\OrgFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

/**
 * @method static OrgFactory factory()
 */
class Org extends Model
{
    use HasFactory, HasSlug, SoftDeletes;

    protected $fillable = [
        'name',
    ];

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class);
    }

    public function associations(): HasMany
    {
        return $this->hasMany(Association::class);
    }

    public function workflowTemplates(): HasMany
    {
        return $this->hasMany(WorkflowTemplate::class);
    }

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }

    public function donorPortfolios(): HasMany
    {
        return $this->hasMany(DonorPortfolio::class);
    }

    public function performanceCards(): HasMany
    {
        return $this->hasMany(PerformanceCard::class);
    }

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    /** @return HasMany<\App\Models\Department, self> */
    public function departments(): HasMany
    {
        return $this->hasMany(\App\Models\Department::class);
    }

    /** @return HasMany<\App\Models\GrantArea, self> */
    public function grantAreas(): HasMany
    {
        return $this->hasMany(\App\Models\GrantArea::class);
    }

    /** @return HasMany<\App\Models\Role, self> */
    public function roles(): HasMany
    {
        return $this->hasMany(\App\Models\Role::class);
    }
}
