<?php

namespace App\Models;

use App\Traits\BelongsToOrg;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Department extends Model
{
    use BelongsToOrg;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'description',
        'org_id',
    ];

    /**
     * Get the users in this department.
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'org_user', 'department_id', 'user_id')
            ->wherePivot('org_id', $this->org_id)
            ->withTimestamps();
    }

    /**
     * Get the performance cards for this department.
     */
    public function performanceCards(): HasMany
    {
        return $this->hasMany(PerformanceCard::class);
    }
}
