<?php

namespace App\Filament\Association\Resources\Orders;

use App\Filament\Association\Resources\Orders\Pages\CreateOrder;
use App\Filament\Association\Resources\Orders\Pages\EditOrder;
use App\Filament\Association\Resources\Orders\Pages\ListOrders;
use App\Filament\Association\Resources\Orders\Pages\ViewOrder;
use App\Filament\Association\Resources\Orders\Schemas\OrderForm;
use App\Filament\Association\Resources\Orders\Schemas\OrderInfolist;
use App\Filament\Association\Resources\Orders\Tables\OrdersTable;
use App\Models\Order;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class OrderResource extends Resource
{
    protected static ?string $model = Order::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::ClipboardDocumentList;

    public static function getNavigationLabel(): string
    {
        return __('order.orders');
    }

    public static function getModelLabel(): string
    {
        return __('order.order');
    }

    public static function getPluralModelLabel(): string
    {
        return __('order.orders');
    }

    public static function form(Schema $schema): Schema
    {
        return OrderForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return OrderInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return OrdersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListOrders::route('/'),
            'create' => CreateOrder::route('/create'),
            'view' => ViewOrder::route('/{record}'),
            'edit' => EditOrder::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.projects');
    }
}
