<?php

namespace App\Filament\Admin\Resources\ProjectCharters\Pages;

use App\Filament\Admin\Resources\ProjectCharters\ProjectCharterResource;
use App\Filament\Admin\Resources\ProjectCharters\Schemas\ProjectCharterProgressInfolist;
use Filament\Actions\EditAction;
use Filament\Resources\Pages\ViewRecord;
use Filament\Schemas\Schema;

class ViewProgressProjectCharter extends ViewRecord
{
    protected static string $resource = ProjectCharterResource::class;

    public static function getNavigationLabel(): string
    {
        return __('project_charter.view_progress');
    }

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),
        ];
    }

    public function infolist(Schema $schema): Schema
    {
        return ProjectCharterProgressInfolist::configure($schema);
    }
}
