<?php

namespace App\Filament\Admin\Resources\ProjectCharters\Pages;

use App\Enums\RiskLevel;
use App\Filament\Admin\Resources\ProjectCharters\ProjectCharterResource;
use BackedEnum;
use Filament\Actions\AssociateAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\DissociateAction;
use Filament\Actions\DissociateBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Infolists\Components\TextEntry;
use Filament\Resources\Pages\ManageRelatedRecords;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ManageProjectRisks extends ManageRelatedRecords
{
    protected static string $resource = ProjectCharterResource::class;

    protected static string $relationship = 'risks';

    protected static string|BackedEnum|null $navigationIcon = Heroicon::ExclamationTriangle;

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label(__('risk_register.name'))
                    ->required(),
                Textarea::make('description')
                    ->label(__('risk_register.description'))
                    ->columnSpanFull(),
                Select::make('incident_likelihood')
                    ->label(__('risk_register.incident_likelihood'))
                    ->options(RiskLevel::class)
                    ->required(),
                Select::make('impact_level')
                    ->label(__('risk_register.impact_level'))
                    ->options(RiskLevel::class)
                    ->required(),
                TextInput::make('impact_on_cost')
                    ->label(__('risk_register.impact_on_cost'))
                    ->numeric(),
                TextInput::make('impact_on_time')
                    ->label(__('risk_register.impact_on_time'))
                    ->numeric(),
                Textarea::make('mitigation_plan')
                    ->label(__('risk_register.mitigation_plan'))
                    ->columnSpanFull(),
                Textarea::make('contingency_plan')
                    ->label(__('risk_register.contingency_plan'))
                    ->columnSpanFull(),
                TextInput::make('financial_contingency')
                    ->label(__('risk_register.financial_contingency'))
                    ->numeric(),
                TextInput::make('technical_contingency')
                    ->label(__('risk_register.technical_contingency'))
                    ->numeric(),
            ]);
    }

    public function infolist(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('name'),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->modelLabel(__('risk_register.risk_register'))
            ->pluralModelLabel(__('risk_register.risk_registers'))
            ->recordTitleAttribute('name')
            ->columns([
                TextColumn::make('name')
                    ->label(__('risk_register.name'))
                    ->searchable(),
                TextColumn::make('incident_likelihood')
                    ->label(__('risk_register.incident_likelihood'))
                    ->badge()
                    ->searchable(),
                TextColumn::make('impact_level')
                    ->label(__('risk_register.impact_level'))
                    ->badge()
                    ->searchable(),
                TextColumn::make('impact_on_cost')
                    ->label(__('risk_register.impact_on_cost'))
                    ->numeric()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('impact_on_time')
                    ->label(__('risk_register.impact_on_time'))
                    ->numeric()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('financial_contingency')
                    ->label(__('risk_register.financial_contingency'))
                    ->numeric()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('technical_contingency')
                    ->label(__('risk_register.technical_contingency'))
                    ->numeric()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('createdBy.name')
                    ->label(__('common.created_by'))
                    ->sortable(),
                TextColumn::make('created_at')
                    ->label(__('common.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->label(__('common.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('deleted_at')
                    ->label(__('common.deleted_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->headerActions([
                CreateAction::make(),
                AssociateAction::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
                DissociateAction::make(),
                DeleteAction::make(),
                ForceDeleteAction::make(),
                RestoreAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DissociateBulkAction::make(),
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ])
            ->modifyQueryUsing(fn (Builder $query) => $query
                ->withoutGlobalScopes([
                    SoftDeletingScope::class,
                ]));
    }

    public static function getNavigationLabel(): string
    {
        return __('risk_register.manage_risk_registers');
    }

    public function getTitle(): string
    {
        return __('risk_register.risk_registers');
    }
}
