<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Tables;

use App\Enums\ProjectManner;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class PerformanceCardTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('department.name')
                    ->label(__('performance_card.department'))
                    ->searchable()
                    ->sortable(),

                TextColumn::make('project_manner')
                    ->label(__('performance_card.project_manner'))
                    ->formatStateUsing(fn (ProjectManner $state): string => $state->getLabel())
                    ->badge()
                    ->color(fn (ProjectManner $state): string => $state->getColor()),

                TextColumn::make('goal')
                    ->label(__('performance_card.goal'))
                    ->limit(50)
                    ->searchable(),

                TextColumn::make('grantAreas.name')
                    ->label(__('performance_card.grant_areas'))
                    ->badge()
                    ->separator(','),

                TextColumn::make('assignees.name')
                    ->label(__('performance_card.assignees'))
                    ->badge()
                    ->separator(','),

                TextColumn::make('results_count')
                    ->label(__('performance_card.results'))
                    ->counts('results')
                    ->badge(),

                TextColumn::make('createdBy.name')
                    ->label(__('performance_card.created_by'))
                    ->searchable()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('created_at')
                    ->label(__('common.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('updated_at')
                    ->label(__('common.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('department_id')
                    ->label(__('performance_card.department'))
                    ->relationship('department', 'name')
                    ->preload(),

                SelectFilter::make('project_manner')
                    ->label(__('performance_card.project_manner'))
                    ->options(ProjectManner::getOptions()),

                TrashedFilter::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ])
            ->defaultSort('created_at', 'desc');
    }
}
