<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Schemas;

use App\Models\Initiative;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Components\ViewEntry;
use Filament\Schemas\Components\Flex;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Filament\Support\Enums\FontWeight;

class InitiativeInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Flex::make([
                    // Right Column - Initiative Information
                    Grid::make(1)
                        ->schema([
                            // Initiative Information
                            Section::make(__('initiative.initiative_information'))
                                ->icon('heroicon-o-rocket-launch')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            TextEntry::make('id')
                                                ->label(__('initiative.initiative_number'))
                                                ->weight(FontWeight::SemiBold)
                                                ->color('gray')
                                                ->badge()
                                                ->prefix('#'),

                                            TextEntry::make('name')
                                                ->label(__('initiative.name'))
                                                ->weight(FontWeight::SemiBold)
                                                ->icon('heroicon-o-rocket-launch'),

                                            TextEntry::make('start_date')
                                                ->label(__('initiative.start_date'))
                                                ->date()
                                                ->icon('heroicon-o-calendar-days')
                                                ->color('success'),

                                            TextEntry::make('expected_end_date')
                                                ->label(__('initiative.expected_end_date'))
                                                ->date()
                                                ->icon('heroicon-o-calendar')
                                                ->color('warning'),

                                            TextEntry::make('performanceCard.department.name')
                                                ->label(__('initiative.department'))
                                                ->icon('heroicon-o-building-office')
                                                ->color('primary'),
                                        ]),

                                    TextEntry::make('description')
                                        ->label(__('initiative.description'))
                                        ->html()
                                        ->columnSpanFull()
                                        ->placeholder(__('initiative.no_description')),

                                    TextEntry::make('grantAreas.name')
                                        ->label(__('initiative.grant_areas'))
                                        ->badge()
                                        ->color('gray')
                                        ->separator(' ')
                                        ->columnSpanFull()
                                        ->placeholder(__('initiative.no_grant_areas')),
                                ]),

                            // Operation Goals Section
                            Section::make(__('initiative_operation_goal.operation_goals'))
                                ->icon('heroicon-o-flag')
                                ->headerActions([
                                    // TODO: Add Goal action
                                ])
                                ->schema([
                                    ViewEntry::make('goals')
                                        ->view('filament.admin.performance-cards.initiative-goal')
                                        ->columnSpanFull(),
                                ]),
                        ]),

                    // Left Column - Initiative Determinants & Operational Indicators
                    Grid::make(1)
                        ->schema([
                            // Initiative Determinants
                            Section::make(__('initiative.initiative_determinants'))
                                ->icon('heroicon-o-calculator')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            // TextEntry::make('expected_cost')
                                            //     ->label(__('initiative.estimated_cost'))
                                            //     ->numeric(2)
                                            //     ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                            //     ->icon('heroicon-o-banknotes')
                                            //     ->color('primary'),

                                            // TextEntry::make('actual_cost')
                                            //     ->label(__('initiative.actual_cost'))
                                            //     ->numeric(2)
                                            //     ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                            //     ->icon('heroicon-o-currency-dollar')
                                            //     ->color('success'),

                                            // TextEntry::make('emergency_reserve')
                                            //     ->label(__('initiative.emergency_reserve'))
                                            //     ->numeric(2)
                                            //     ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                            //     ->icon('heroicon-o-shield-check')
                                            //     ->color('warning'),

                                            // TextEntry::make('reserve_status')
                                            //     ->label(__('initiative.reserve_status'))
                                            //     ->numeric(2)
                                            //     ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                            //     ->icon('heroicon-o-information-circle')
                                            //     ->color('gray'),

                                            // TextEntry::make('estimated_budget')
                                            //     ->label(__('initiative.estimated_budget'))
                                            //     ->numeric(2)
                                            //     ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                            //     ->icon('heroicon-o-chart-pie')
                                            //     ->color('info'),

                                            // TextEntry::make('total_expenses')
                                            //     ->label(__('initiative.total_expenses'))
                                            //     ->numeric(2)
                                            //     ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                            //     ->icon('heroicon-o-receipt-percent')
                                            //     ->color('danger'),
                                        ]),
                                ]),

                            // Operational Indicators
                            Section::make(__('initiative.operational_indicators'))
                                ->icon('heroicon-o-chart-bar-square')
                                ->schema([
                                    Grid::make(2)
                                        ->schema([
                                            // TextEntry::make('overall_progress')
                                            //     ->label(__('initiative.technical_completion_percentage'))
                                            //     // ->formatStateUsing(fn() => '0')
                                            //     ->suffix('%')
                                            //     ->icon('heroicon-o-cog')
                                            //     ->color('primary')
                                            //     ->weight(FontWeight::Bold),

                                            // TextEntry::make('financial_completion_percentage')
                                            //     ->label(__('initiative.financial_completion_percentage'))
                                            //     ->suffix('%')
                                            //     ->icon('heroicon-o-currency-dollar')
                                            //     ->color('success')
                                            //     ->weight(FontWeight::Bold),
                                        ]),
                                ]),

                            // TODO: Initiative Results Section
                            Section::make(__('initiative_result.initiative_results'))
                                ->icon('heroicon-o-chart-bar')
                                ->headerActions([
                                    // TODO: Add Result action
                                ])
                                ->schema([
                                    ViewEntry::make('results')
                                        ->view('filament.admin.performance-cards.initiative-result')
                                        ->columnSpanFull(),
                                ]),
                        ]),
                ])->columnSpanFull(),
            ]);
    }
}
