<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Resources\Initiatives\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class InitiativeForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label(__('initiative.name'))
                    ->required()
                    ->maxLength(255),
                Textarea::make('description')
                    ->label(__('initiative.description'))
                    ->columnSpanFull()
                    ->maxLength(10000),

                // TODO: validate start_date based on wallet
                DatePicker::make('start_date')
                    ->label(__('initiative.start_date'))
                    ->required(),
                DatePicker::make('expected_end_date')
                    ->label(__('initiative.expected_end_date'))
                    ->required(),
                TextInput::make('created_by')
                    ->label(__('initiative.created_by'))
                    ->required()
                    ->numeric(),
            ]);
    }
}
