<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Pages;

use App\Filament\Admin\Resources\PerformanceCards\Forms\PerformanceWalletInfolist;
use App\Filament\Admin\Resources\PerformanceCards\PerformanceCardResource;
use Filament\Resources\Pages\ViewRecord;
use Filament\Schemas\Schema;

class ViewPerformanceWallet extends ViewRecord
{
    protected static string $resource = PerformanceCardResource::class;

    public static function getNavigationLabel(): string
    {
        return __('performance_wallet.performance_wallet');
    }

    public function infolist(Schema $schema): Schema
    {
        return PerformanceWalletInfolist::make($schema);
    }
}
