<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Pages;

use App\Filament\Admin\Resources\PerformanceCards\Forms\PerformanceCardInfolist;
use App\Filament\Admin\Resources\PerformanceCards\PerformanceCardResource;
use App\Models\PerformanceWallet;
use Filament\Actions\Action;
use Filament\Actions\EditAction;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\ViewRecord;
use Filament\Schemas\Schema;

class ViewPerformanceCard extends ViewRecord
{
    protected static string $resource = PerformanceCardResource::class;

    public static function getNavigationLabel(): string
    {
        return __('performance_card.performance_card');
    }

    protected function getHeaderActions(): array
    {
        return [
            Action::make('create_wallet')
                ->label(__('performance_wallet.create_wallet'))
                ->color('success')
                ->icon('heroicon-o-plus')
                ->visible(! $this->record->wallet)
                ->modalHeading(__('performance_wallet.create_wallet'))
                ->modalSubmitActionLabel(__('filament-actions::create.single.modal.actions.create.label'))
                ->schema($this->getWalletForm())
                ->action(function (array $data): void {
                    // Create new wallet
                    $data['performance_card_id'] = $this->record->id;
                    PerformanceWallet::create($data);
                    Notification::make()
                        ->title(__('performance_wallet.wallet_created'))
                        ->success()
                        ->send();

                    // Refresh the record to show updated wallet information
                    $this->record->refresh();
                }),
            EditAction::make(),
        ];
    }

    public function infolist(Schema $schema): Schema
    {
        return PerformanceCardInfolist::make($schema);
    }

    protected function getWalletForm(): array
    {
        return [
            TextInput::make('name')
                ->label(__('performance_wallet.name'))
                ->required()
                ->maxLength(255)
                ->helperText(__('performance_wallet.name_helper')),

            DatePicker::make('start_date')
                ->label(__('performance_wallet.start_date'))
                ->required(),

            DatePicker::make('expected_end_date')
                ->label(__('performance_wallet.expected_end_date'))
                ->required()
                ->after('start_date'),

            Textarea::make('description')
                ->label(__('performance_wallet.description'))
                ->required()
                ->rows(4)
                ->maxLength(1000)
                ->helperText(__('performance_wallet.description_helper')),
        ];
    }
}
