<?php

namespace App\Filament\Admin\Resources\PerformanceCards\Forms;

use App\Enums\ProjectManner;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class PerformanceCardForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make(__('performance_card.basic_information'))
                    ->schema([
                        Select::make('department_id')
                            ->label(__('performance_card.department'))
                            ->relationship('department', 'name')
                            ->required()
                            ->preload()
                            ->searchable()
                            ->helperText(__('performance_card.department_helper')),

                        Select::make('project_manner')
                            ->label(__('performance_card.project_manner'))
                            ->required()
                            ->options(ProjectManner::getOptions())
                            ->default(ProjectManner::DEVELOPMENTAL->value),

                        Textarea::make('goal')
                            ->label(__('performance_card.goal'))
                            ->required()
                            ->rows(3)
                            ->maxLength(1000)
                            ->helperText(__('performance_card.goal_helper')),
                    ])
                    ->columns(1),

                Section::make(__('performance_card.relationships'))
                    ->schema([
                        Select::make('grantAreas')
                            ->label(__('performance_card.grant_areas'))
                            ->multiple()
                            ->relationship('grantAreas', 'name')
                            ->preload()
                            ->searchable()
                            ->helperText(__('performance_card.grant_areas_helper')),

                        Select::make('assignees')
                            ->label(__('performance_card.assignees'))
                            ->multiple()
                            ->relationship('assignees', 'name')
                            ->preload()
                            ->searchable()
                            ->helperText(__('performance_card.assignees_helper')),
                    ])
                    ->columns(1),

                Section::make(__('performance_card.card_results'))
                    ->schema([
                        Repeater::make('results')
                            ->relationship('results')
                            ->simple(
                                TextInput::make('name')
                                    ->label(__('performance_card.result'))
                                    ->required()
                                    ->maxLength(500),
                            ),
                    ])
                    ->columns(1),
            ]);
    }
}
