<?php

namespace App\Filament\Admin\Resources\Orders\Pages;

use App\Filament\Admin\Resources\Orders\Forms\OrderInfolist;
use App\Filament\Admin\Resources\Orders\OrderResource;
use App\Workflows\Actions\WorkflowActions;
use Filament\Actions\EditAction;
use Filament\Resources\Pages\ViewRecord;
use Filament\Schemas\Schema;

class ViewOrder extends ViewRecord
{
    protected static string $resource = OrderResource::class;

    public function mount(int|string $record): void
    {
        parent::mount($record);

        // Auto-initialize workflow if none exists
        WorkflowActions::autoInitializeWorkflow($this->record);
    }

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),
            ...WorkflowActions::getActions($this->record, fn ($keys) => $this->refreshFormData($keys)),
        ];
    }

    public function infolist(Schema $schema): Schema
    {
        return OrderInfolist::make($schema);
    }
}
