<?php

namespace App\Filament\Admin\Resources\GrantAreas\Forms;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class GrantAreaForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make(__('grant_area.grant_area_information'))
                    ->description(__('grant_area.grant_area_information_description'))
                    ->schema([
                        TextInput::make('name')
                            ->label(__('common.name'))
                            ->placeholder(__('grant_area.grant_area_name_placeholder'))
                            ->maxLength(255)
                            ->required()
                            ->unique(modifyRuleUsing: function ($rule, $get) {
                                // Make unique within the current organization
                                return $rule->where('org_id', filament()->getTenant()?->id);
                            }),
                    ])
                    ->columns(1),
            ]);
    }
}
