<?php

namespace App\Filament\Admin\Resources\Departments\Forms;

use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class DepartmentForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make(__('common.department_information'))
                    ->description(__('common.department_information_description'))
                    ->schema([
                        TextInput::make('name')
                            ->label(__('common.name'))
                            ->placeholder(__('common.department_name_placeholder'))
                            ->maxLength(255)
                            ->required()
                            ->unique(modifyRuleUsing: function ($rule, $get) {
                                // Make unique within the current organization
                                return $rule->where('org_id', filament()->getTenant()?->id);
                            }),

                        Textarea::make('description')
                            ->label(__('common.description'))
                            ->placeholder(__('common.department_description_placeholder'))
                            ->rows(3)
                            ->maxLength(1000),
                    ]),
            ]);
    }
}
