<?php

namespace App\Filament\Admin\Resources\Associations;

use App\Filament\Admin\Resources\Associations\Forms\AssociationForm;
use App\Filament\Admin\Resources\Associations\Pages\CreateAssociation;
use App\Filament\Admin\Resources\Associations\Pages\EditAssociation;
use App\Filament\Admin\Resources\Associations\Pages\ListAssociations;
use App\Filament\Admin\Resources\Associations\Pages\ViewAssociation;
use App\Filament\Admin\Resources\Associations\Tables\AssociationTable;
use App\Models\Association;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AssociationResource extends Resource
{
    protected static ?string $model = Association::class;

    protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-building-library';

    protected static ?int $navigationSort = 2;

    public static function getModelLabel(): string
    {
        return __('association.association');
    }

    public static function getPluralModelLabel(): string
    {
        return __('association.associations');
    }

    public static function form(Schema $schema): Schema
    {
        return AssociationForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AssociationTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAssociations::route('/'),
            'create' => CreateAssociation::route('/create'),
            'view' => ViewAssociation::route('/{record}'),
            'edit' => EditAssociation::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.orders');
    }
}
