<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum RequirementStatus: string implements HasColor, HasLabel
{
    case PENDING = 'pending';
    case APPROVED = 'approved';
    case REJECTED = 'rejected';
    case ASK_MODIFICATION = 'ask_modification';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::PENDING => __('order_requirement.pending'),
            self::APPROVED => __('order_requirement.approved'),
            self::REJECTED => __('order_requirement.rejected'),
            self::ASK_MODIFICATION => __('order_requirement.ask_modification'),
        };
    }

    public function getColor(): string|array|null
    {
        return match ($this) {
            self::PENDING => 'warning',
            self::APPROVED => 'success',
            self::REJECTED => 'danger',
            self::ASK_MODIFICATION => 'info',
        };
    }

    public static function getOptions(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->getLabel(),
        ])->toArray();
    }
}
