<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum ProjectManner: string implements HasColor, HasLabel
{
    case DEVELOPMENTAL = 'developmental';
    case SUPPORT = 'support';
    case EMPOWERMENT = 'empowerment';
    case INVESTMENT = 'investment';

    public function getLabel(): ?string
    {
        return __('performance_card.manner.'.$this->value);
    }

    public function getColor(): string|array|null
    {
        return match ($this) {
            self::DEVELOPMENTAL => 'success',
            self::SUPPORT => 'info',
            self::EMPOWERMENT => 'warning',
            self::INVESTMENT => 'primary',
        };
    }

    public static function getOptions(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->getLabel(),
        ])->toArray();
    }
}
