<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum ProjectCharterState: string implements HasColor, HasLabel
{
    case ACTIVE = 'active'; // in workflow
    case COMPLETED = 'completed';
    case CANCELED = 'canceled';
    case SUSPENDED = 'suspended';

    public function getLabel(): ?string
    {
        return __('performance_card.manner.'.$this->value);
    }

    public function getColor(): string|array|null
    {
        return match ($this) {
            self::ACTIVE => 'info',
            self::COMPLETED => 'success',
            self::CANCELED => 'warning',
            self::SUSPENDED => 'primary',
        };
    }

    public static function getOptions(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->getLabel(),
        ])->toArray();
    }
}
